<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudDomains;

class RetrieveGoogleDomainsDnsRecordsResponse extends \Google\Collection
{
  protected $collection_key = 'rrset';
  /**
   * When present, there are more results to retrieve. Set `page_token` to this
   * value on a subsequent call to get the next page of results.
   *
   * @var string
   */
  public $nextPageToken;
  protected $rrsetType = ResourceRecordSet::class;
  protected $rrsetDataType = 'array';

  /**
   * When present, there are more results to retrieve. Set `page_token` to this
   * value on a subsequent call to get the next page of results.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
  /**
   * The resource record set resources (DNS Zone records).
   *
   * @param ResourceRecordSet[] $rrset
   */
  public function setRrset($rrset)
  {
    $this->rrset = $rrset;
  }
  /**
   * @return ResourceRecordSet[]
   */
  public function getRrset()
  {
    return $this->rrset;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(RetrieveGoogleDomainsDnsRecordsResponse::class, 'Google_Service_CloudDomains_RetrieveGoogleDomainsDnsRecordsResponse');
